<?php 
    include 'db_connect.php'; 
    include 'header.php'; 
?>

<section class="page-hero" style="height: 40vh; background: linear-gradient(rgba(102, 0, 0, 0.5), rgba(102, 0, 0, 0.5)), url('images/judge-s-gavel-table-court-room-closeup-concept-justice-law-generative-ai.jpg') no-repeat center center/cover;">
    <div class="container">
        <h1>Daily Appeal List</h1>
        <p>View scheduled Arguments, Mentions, and Judgments for Civil Appeals.</p>
    </div>
</section>

<section class="content-section reveal" style="padding: 80px 8%; background-color: #fff;">
    
    <div class="filter-container" style="background: #f4f4f4; padding: 20px; border-radius: 8px; margin-bottom: 30px; display: flex; gap: 20px; align-items: end; flex-wrap: wrap;">
        <div class="form-group" style="display: flex; flex-direction: column;">
            <label style="font-size: 0.9rem; margin-bottom: 5px; color: #555; font-weight: 600;">Filter by Year:</label>
            <select class="form-control" style="padding: 10px 15px; border: 1px solid #ccc; border-radius: 4px; min-width: 200px;">
                <option>All</option>
                <option>2026</option>
                <option>2025</option>
            </select>
        </div>
        <div class="form-group" style="display: flex; flex-direction: column;">
            <label style="font-size: 0.9rem; margin-bottom: 5px; color: #555; font-weight: 600;">Month:</label>
            <select class="form-control" style="padding: 10px 15px; border: 1px solid #ccc; border-radius: 4px; min-width: 200px;">
                <option>All</option>
                <option>February</option>
                <option>March</option>
            </select>
        </div>
        <button class="btn-gold" style="border:none; cursor:pointer; height: 40px;">Filter</button>
    </div>

    <div class="table-responsive" style="overflow-x: auto;">
        <table class="custom-table" style="width: 100%; border-collapse: collapse; margin-top: 20px; background: white; box-shadow: 0 5px 15px rgba(0,0,0,0.05);">
            <thead>
                <tr style="background-color: var(--primary-color); color: white;">
                    <th style="padding: 15px; text-align: left;">Date</th>
                    <th style="padding: 15px; text-align: left;">List Type</th>
                    <th style="padding: 15px; text-align: left;">Download</th>
                </tr>
            </thead>
            <tbody>
                <tr style="border-bottom: 1px solid #eee;">
                    <td style="padding: 15px; color: #444;">2026-02-02</td>
                    <td style="padding: 15px; color: #444;">02ND FEB 2026 - ARGUMENT ROLL (COURT 1)</td>
                    <td style="padding: 15px;"><a href="#" class="btn-download" style="background-color: #bfa15f; color: white; padding: 8px 15px; font-size: 0.75rem; text-decoration: none; border-radius: 3px;">Download PDF</a></td>
                </tr>
                <tr style="border-bottom: 1px solid #eee; background-color: #fcfcfc;">
                    <td style="padding: 15px; color: #444;">2026-02-03</td>
                    <td style="padding: 15px; color: #444;">03RD FEB 2026 - MENTION & SUPPORT LIST</td>
                    <td style="padding: 15px;"><a href="#" class="btn-download" style="background-color: #bfa15f; color: white; padding: 8px 15px; font-size: 0.75rem; text-decoration: none; border-radius: 3px;">Download PDF</a></td>
                </tr>
                <tr style="border-bottom: 1px solid #eee;">
                    <td style="padding: 15px; color: #444;">2026-02-04</td>
                    <td style="padding: 15px; color: #444;">04TH FEB 2026 - JUDGMENT DELIVERY LIST</td>
                    <td style="padding: 15px;"><a href="#" class="btn-download" style="background-color: #bfa15f; color: white; padding: 8px 15px; font-size: 0.75rem; text-decoration: none; border-radius: 3px;">Download PDF</a></td>
                </tr>
                <tr style="border-bottom: 1px solid #eee; background-color: #fcfcfc;">
                    <td style="padding: 15px; color: #444;">2026-02-05</td>
                    <td style="padding: 15px; color: #444;">05TH FEB 2026 - LAND ACQUISITION APPEALS</td>
                    <td style="padding: 15px;"><a href="#" class="btn-download" style="background-color: #bfa15f; color: white; padding: 8px 15px; font-size: 0.75rem; text-decoration: none; border-radius: 3px;">Download PDF</a></td>
                </tr>
            </tbody>
        </table>
        
        <div style="margin-top: 20px; text-align: right; font-size: 0.9rem; color: #666;">
            Showing 1 to 4 of 60 entries 
            <span style="margin-left: 10px;">
                <button style="padding: 5px 10px; border: 1px solid #ddd; background: white; cursor: pointer;">Previous</button>
                <button style="padding: 5px 10px; border: 1px solid var(--gold-accent); background: var(--gold-accent); color: white; cursor: pointer;">1</button>
                <button style="padding: 5px 10px; border: 1px solid #ddd; background: white; cursor: pointer;">Next</button>
            </span>
        </div>
    </div>

</section>

<script>
    window.addEventListener('scroll', function() {
        var reveals = document.querySelectorAll('.reveal');
        for(var i = 0; i < reveals.length; i++){
            var windowheight = window.innerHeight;
            var revealtop = reveals[i].getBoundingClientRect().top;
            var revealpoint = 150;
            if(revealtop < windowheight - revealpoint){
                reveals[i].classList.add('active');
            }
        }
    });
</script>

<?php include 'footer.php'; ?>